/* 
 * Custom JS interactions
 */

function customFunctions() {
    slideLoad(0)
}

function checkCourseProgress(isStarting = false, forceGoTo = false){
    if(isStarting)
        slideLoad(1)
    
    if(forceGoTo){
        if(courseStatus.intro_ended > 0){
            setTimeout(() => {
                $(".contentor_hall").fadeOut().addClass("d-none")
                GoToRoom(courseStatus.currentRoom)
                $('.container_keys_points').removeClass("d-none");
            }, 50);
        }
    }
  
    // Fill avatar
    $('.avatar_chosen').attr('src',`images/avatars/avatar_chosen_${courseStatus.avatarId}.png`)
    $('.bg_avatar_small .avatar_img').attr('src',`images/avatars/avatar_chosen_${courseStatus.avatarId}.png`)
    // Fill keys
    $('.bg_boder_keys').children().addClass("d-none")
    $(`.bg_boder_keys .keys_bar_${courseStatus.currentRoom}`).removeClass("d-none")

    // Fill progress bar
    $(".progress_bar_top").children().addClass("d-none")
    $(`.progress_bar_top .prog_bar_${(courseStatus.rooms_completed.length == 0 ? 1 : courseStatus.rooms_completed.length)}`).removeClass("d-none")
    
    // Fill score
    updateScore()

    setTimeout(() => {
        handleRoomVisitedTooltips()
    }, 500);
}

function parseData(saveData) {    
    Object.keys(saveData).forEach((index) => {
        const element = saveData[index];
        if (!isNaN(element)) {
            saveData[index] = parseFloat(element);
        }
    });

    courseSave();
}

function previousInstruction() {
    playerSFXPlay('robotBtnSimpleClick');
    var id = $('.instruction-slide.active').data('instruction-slide');
    var idParent = $('.instruction-slide.active').parent().parent().data('instruction');
    var idPrev = id - 1;
    
    if ( $('#instruction-slide-'+idParent+'-'+idPrev).length > 0 ) {
        $('.instruction-slide.active').removeClass('active');
        $('.instruction-slide').hide()
        $('#instruction-slide-'+idParent+'-'+idPrev).addClass('active');
        $('#instruction-slide-'+idParent+'-'+idPrev).show()
    }
}

function nextInstruction() {
    playerSFXPlay('robotBtnSimpleClick');
    var id = $('.instruction-slide.active').data('instruction-slide');
    var idParent = $('.instruction-slide.active').parent().parent().data('instruction');
    var idNext = id + 1;
    
    if ( $('#instruction-slide-'+idParent+'-'+idNext).length > 0 ) {
        $('.instruction-slide.active').removeClass('active');
        $('.instruction-slide').hide()
        $('#instruction-slide-'+idParent+'-'+idNext).addClass('active');
        $('#instruction-slide-'+idParent+'-'+idNext).show()
    }
}

function badgeConfetti() {
    $('.confetti-wrapper').removeClass("d-none")
    // Whenever you get a new badge, a screen enters and this animation plays out
    for (var i = 0; i < 150; i++) {
        create(i);
    }
    
    function create(i) {
        var colourIdx = Math.ceil(Math.random() * 3);
        var colour = "pink";
        switch(colourIdx) {
        case 1:
            colour = "red";
            break;
        case 2:
            colour = "purple";
            break;
        default:
            colour = "pink";
        }
        $('<div class="confetti-'+i+' '+colour+'"></div>').css({
        "width" : "5px",
        "height" : "10px",
        "top" : -Math.random()*20+"%",
        "left" : Math.random()*100+"%",
        "transform" : "rotate("+Math.random()*360+"deg)"
        }).appendTo('.confetti-wrapper');  
        drop(i);
    }
    
    function drop(x) {
        $('.confetti-'+x).animate({
        top: "100%",
        left: "+="+Math.random()*15+"%"
        }, Math.random()*2000 + 2000, function() {
        setTimeout(() => {
            $('.confetti-wrapper').remove()
        }, 500);
        });
    }
}

function openInstructions() {
    /*$('.instructions-area').show();
    $('.instructions-area').css({
        'background-color': 'var(--clr-bg-blur-dk)',
    })
    $('.instructions-slide').hide();
    $('#instruction-button-window-0, #instruction-button-window-0 #instruction-slide-0-0').show();
    $('#instruction-button-window-0, #instruction-button-window-0 #instruction-slide-0-0').addClass('active');*/
    playerSFXPlay('robotBtnSimpleClick');
    const pdfUrl = 'documents/instructions.pdf';
    OpenExternalPopup(pdfUrl)
}

function openLocation() {
    playerSFXPlay('robotBtnSimpleClick');

    $(".map_container .cadeado").removeClass("d-none")
    $(".map_container .marker").addClass("d-none")
    for (let index = 1; index <= courseStatus.rooms_completed.length; index++) {
        if(courseStatus.rooms_completed[index] == 1){
            $(`.map_container .cadeado[data-room=${index}]`).addClass("d-none")
        }
    }

    if(courseStatus.rooms_completed.length == 6){
        $(`.map_container .tooltip`).removeClass("c-default")
        for (let index = 0; index < courseStatus.rooms_completed.length; index++) {
            $(`.map_container .tooltip[data-room=${index}]`).attr("onclick", `GoToRoom(${index}, true);closeLocation();`)
        }
    }else{
        $(`.map_container .tooltip`).addClass("c-default")
        $(`.map_container .tooltip`).removeAttr("onclick")
    }
        

    $(`.map_container .cadeado[data-room=${courseStatus.currentRoom}]`).addClass("d-none")
    $(`.map_container .marker[data-room=${courseStatus.currentRoom}]`).removeClass("d-none")
    $(".map_container").fadeIn().removeClass("d-none")
}

function closeLocation(){
    playerSFXPlay('robotBtnSimpleClick');
    $(".map_container").fadeOut().addClass("d-none")
}

function closeInstructions() {
    $('.instructions-area').hide()
    $('.instruction-slide').removeClass('active');
    $('.instruction-slide').hide();
}


// PDF Viewer
function OpenExternalPopup(link){
    // Fixes dual-screen position                             Most browsers      Firefox
    const dualScreenLeft = window.screenLeft !==  undefined ? window.screenLeft : window.screenX;
    const dualScreenTop = window.screenTop !==  undefined   ? window.screenTop  : window.screenY;

    const width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
    const height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;
    const w = 1200;
    const h = 800;

    const systemZoom = width / window.screen.availWidth;
    const left = (width - w) / 2 / systemZoom + dualScreenLeft
    const top = ((height - h) / 2 / systemZoom + dualScreenTop) + 80

    window.open(link, '_blank', `toolbar=0,location=0,menubar=0,width=1200,height=800,top=${top},left=${left}`);
}

/* COMPLETAR SALA */
function CompleteRoom(id){
    courseStatus.rooms_completed[0] = "-";
    courseStatus.rooms_completed[id] = 1
    courseStatus.progress = id;
    courseSave()

    if(id == 5 && courseStatus.completed == 0){
        sendInteraction(0, "Correct answers: " + courseStatus.correctAnswers)
        sendInteraction(1, "Wrong answers: " + courseStatus.wrongAnswers)
        sendInteraction(2, "Total answers: " + (courseStatus.wrongAnswers + courseStatus.correctAnswers))
        sendInteraction(3, "Total score: " + courseStatus.score)
        sendInteraction(4, "Chosen avatar: " + avatar[courseStatus.avatarId].name.replace("This is", '').replace("Meet", '').replace(".", '').trim());

        courseStatus.completed = 1;
        courseComplete()
    }
}

function isRoomCompleted(id){
    return courseStatus.rooms_completed[id] == 1
}

/* CLICKS PONTOS SALA */
function showHotSpot(room, hotspotId) {
    Parallax.stop()
    switch (room) {
        case 1:

            $(".btnNextRoom_01").addClass("d-none")

            switch (hotspotId) {
                case 1:
                    // Obrigatório
                    playerSFXPlay('robotBtnSimpleClick');
                    $('.chat_bot_room_1').fadeIn().removeClass("d-none");

                    $('.multipleChoice_room_1').addClass("d-none");
                    $('.photoChoice_room_1').addClass("d-none");
                    $('.dragChoice_room_1').addClass("d-none");  
                    $('.sendDrawing_room_1').addClass("d-none");
                    $('.pObr_a_room1').addClass("ponto_obrigatorio-selected");  
                    break;
                case 2:
                    // Obrigatório
                    playerSFXPlay('robotBtnSimpleClick');
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    $('.multipleChoice_room_1').fadeIn().removeClass("d-none");
                    $('.contentor_room1 .bot_6').fadeIn().removeClass("d-none");
                    $('.contentor_room1 .btn_submit_multiple_room1_1')
                    $('.chat_bot_room_1').addClass("d-none");
                    $('.photoChoice_room_1').addClass("d-none");
                    $('.dragChoice_room_1').addClass("d-none");
                    $('.sendDrawing_room_1').addClass("d-none");
                    $('.pObr_b_room1').addClass("ponto_obrigatorio-selected");   
                    break;
                case 3:
                    //Facultativo
                    playerSFXPlay('robotBtnSimpleClick');
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    $('.photoChoice_room_1').fadeIn().removeClass("d-none");
                    $('.contentor_room1 .bot_7').fadeIn().removeClass("d-none");

                    $('.multipleChoice_room_1').addClass("d-none");
                    $('.chat_bot_room_1').addClass("d-none");
                    $('.dragChoice_room_1').addClass("d-none");
                    $('.sendDrawing_room_1').addClass("d-none");
                    $('.pFac_a_room1').addClass("ponto_facultativo-selected");     
                    break;
                case 4:
                    //Facultativo
                    playerSFXPlay('robotBtnSimpleClick');
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    $('.dragChoice_room_1').fadeIn().removeClass("d-none");
                    $('.contentor_room1 .bot_8').fadeIn().removeClass("d-none");           
                    $('.btn_reset_drag_room1').removeClass("no-click");
                    $('.chat_bot_room_1').addClass("d-none");
                    $('.photoChoice_room_1').addClass("d-none");
                    $('.multipleChoice_room_1').addClass("d-none");
                    $('.sendDrawing_room_1').addClass("d-none");
                    $('.pFac_b_room1').addClass("ponto_facultativo-selected");  

                    setupDragDropRoom1()
                    break;
                case 5:
                    //Facultativo
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    playerSFXPlay('robotBtnSimpleClick');
                    $('.sendDrawing_room_1').fadeIn().removeClass("d-none");
                    $('.contentor_room1 .bot_9').fadeIn().removeClass("d-none");          
                    
                    $('.dragChoice_room_1').addClass("d-none");
                    $('.chat_bot_room_1').addClass("d-none");
                    $('.photoChoice_room_1').addClass("d-none");
                    $('.multipleChoice_room_1').addClass("d-none");
                    $('.pFac_c_room1').addClass("ponto_facultativo-selected");   
                    break;
            }
        break;
        case 2:

            $(".btnNextRoom_02").addClass("d-none")

            switch (hotspotId) {
                case 1:
                    // Obrigatório
                    playerSFXPlay('robotBtnSimpleClick');
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    $('.dragChoice_room_2').fadeIn().removeClass("d-none");
                    // $('.contentor_room2 .bot_8').fadeIn().removeClass("d-none");
                    $('.btn_reset_drag_room2').removeClass("no-click");
                    $('.chat_bot_room_2').addClass("d-none");
                    $('.photoChoice_room_2').addClass("d-none");
                    $('.multipleChoice_room_2').addClass("d-none");
                    $('.sendDrawing_room_2').addClass("d-none");
                    
                    $('.pObr_a_room2').addClass("ponto_obrigatorio-selected");  
                    
                    setupDragDropRoom2()
                    break;
                case 2:
                    // Obrigatório
                    playerSFXPlay('robotBtnSimpleClick');
                    $('.chat_bot_room_2').fadeIn().removeClass("d-none");

                    $('.multipleChoice_room_2').addClass("d-none");
                    $('.photoChoice_room_2').addClass("d-none");
                    $('.dragChoice_room_2').addClass("d-none");  
                    $('.sendDrawing_room_2').addClass("d-none");
                    
                    $('.pObr_b_room2').addClass("ponto_obrigatorio-selected");   
                    break;
                case 3:
                    //Facultativo
                    playerSFXPlay('robotBtnSimpleClick');
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    $('.multipleChoice_room_2').fadeIn().removeClass("d-none");
                    $('.contentor_room2 .bot_6').fadeIn().removeClass("d-none");
                    $('.btn_submit_multiple_room2_1')
                    $('.chat_bot_room_2').addClass("d-none");
                    $('.photoChoice_room_2').addClass("d-none");
                    $('.dragChoice_room_2').addClass("d-none");
                    $('.sendDrawing_room_2').addClass("d-none");
                    
                    $('.pFac_a_room2').addClass("ponto_facultativo-selected");     
                    break;
                case 4:
                    //Facultativo
                    playerSFXPlay('robotBtnSimpleClick');
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    $('.photoChoice_room_2').fadeIn().removeClass("d-none");
                    $('.contentor_room2 .bot_7').fadeIn().removeClass("d-none");

                    $('.multipleChoice_room_2').addClass("d-none");
                    $('.chat_bot_room_2').addClass("d-none");
                    $('.dragChoice_room_2').addClass("d-none");
                    $('.sendDrawing_room_2').addClass("d-none");

                    $('.pFac_b_room2').addClass("ponto_facultativo-selected");  
                    break;
                case 5:
                    //Facultativo
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    playerSFXPlay('robotBtnSimpleClick');
                    $('.sendDrawing_room_2').fadeIn().removeClass("d-none");
                    $('.contentor_room2 .bot_9').fadeIn().removeClass("d-none");          
                    
                    $('.dragChoice_room_2').addClass("d-none");
                    $('.chat_bot_room_2').addClass("d-none");
                    $('.photoChoice_room_2').addClass("d-none");
                    $('.multipleChoice_room_2').addClass("d-none");
                    
                    $('.pFac_c_room2').addClass("ponto_facultativo-selected");   
                    break;
            }
        break;
        case 3:

            $(".btnNextRoom_03").addClass("d-none")

            switch (hotspotId) {
                case 1:
                    //Obrigatório
                    playerSFXPlay('robotBtnSimpleClick');
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    $('.photoChoice_room_3').fadeIn().removeClass("d-none");
                    $('.contentor_room3 .bot_7').fadeIn().removeClass("d-none");

                    $('.multipleChoice_room_3').addClass("d-none");
                    $('.chat_bot_room_3').addClass("d-none");
                    $('.dragChoice_room_3').addClass("d-none");
                    $('.sendDrawing_room_3').addClass("d-none");
                    
                    $('.pObr_a_room3').addClass("ponto_obrigatorio-selected");  
                    break;
                case 2:
                    // Obrigatório
                    playerSFXPlay('robotBtnSimpleClick');
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    $('.dragChoice_room_3').fadeIn().removeClass("d-none");
                    $('.contentor_room3 .bot_8').fadeIn().removeClass("d-none");
                    $('.btn_reset_drag_room3').removeClass("no-click");
                    $('.chat_bot_room_3').addClass("d-none");
                    $('.photoChoice_room_3').addClass("d-none");
                    $('.multipleChoice_room_3').addClass("d-none");
                    $('.sendDrawing_room_3').addClass("d-none");
                    
                    $('.pObr_b_room3').addClass("ponto_obrigatorio-selected");  
                    
                    setupDragDropRoom3()
                    break;
                case 3:
                    // Facultativo
                    playerSFXPlay('robotBtnSimpleClick');
                    $('.chat_bot_room_3').fadeIn().removeClass("d-none");

                    $('.multipleChoice_room_3').addClass("d-none");
                    $('.photoChoice_room_3').addClass("d-none");
                    $('.dragChoice_room_3').addClass("d-none");  
                    $('.sendDrawing_room_3').addClass("d-none");
                    
                    $('.pFac_a_room3').addClass("ponto_facultativo-selected");   
                    break;
                case 4:
                    //Facultativo
                    playerSFXPlay('robotBtnSimpleClick');
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    $('.multipleChoice_room_3').fadeIn().removeClass("d-none");
                    $('.contentor_room3 .bot_6').fadeIn().removeClass("d-none");
                    // $('.btn_submit_multiple_room3_1')
                    $('.chat_bot_room_3').addClass("d-none");
                    $('.photoChoice_room_3').addClass("d-none");
                    $('.dragChoice_room_3').addClass("d-none");
                    $('.sendDrawing_room_3').addClass("d-none");
                    
                    $('.pFac_b_room3').addClass("ponto_facultativo-selected");     
                    break;
                case 5:
                    //Facultativo
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    playerSFXPlay('robotBtnSimpleClick');
                    $('.sendDrawing_room_3').fadeIn().removeClass("d-none");
                    $('.contentor_room3 .bot_9').fadeIn().removeClass("d-none");          
                    
                    $('.dragChoice_room_3').addClass("d-none");
                    $('.chat_bot_room_3').addClass("d-none");
                    $('.photoChoice_room_3').addClass("d-none");
                    $('.multipleChoice_room_3').addClass("d-none");
                    
                    $('.pFac_c_room3').addClass("ponto_facultativo-selected");   
                    break;
            }
        break;
        case 4:

            $(".btnNextRoom_04").addClass("d-none")

            switch (hotspotId) {
                case 1:
                    //Obrigatório
                    playerSFXPlay('robotBtnSimpleClick');
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    $('.multipleChoice_room_4').fadeIn().removeClass("d-none");
                    $('.contentor_room4 .bot_6').fadeIn().removeClass("d-none");
                    $('.btn_submit_multiple_room4_1')
                    $('.chat_bot_room_4').addClass("d-none");
                    $('.photoChoice_room_4').addClass("d-none");
                    $('.dragChoice_room_4').addClass("d-none");
                    $('.sendDrawing_room_4').addClass("d-none");
                    
                    $('.pObr_a_room4').addClass("ponto_obrigatorio-selected");  
                    break;
                case 2:
                    //Obrigatório
                    playerSFXPlay('robotBtnSimpleClick');
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    $('.photoChoice_room_4').fadeIn().removeClass("d-none");

                    $('.multipleChoice_room_4').addClass("d-none");
                    $('.chat_bot_room_4').addClass("d-none");
                    $('.dragChoice_room_4').addClass("d-none");
                    $('.sendDrawing_room_4').addClass("d-none");

                    $('.pObr_b_room4').addClass("ponto_obrigatorio-selected");
                    break;
                case 3:
                    // Facultativo
                    playerSFXPlay('robotBtnSimpleClick');
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    $('.dragChoice_room_4').fadeIn().removeClass("d-none");
                    $('.contentor_room4 .bot_8').fadeIn().removeClass("d-none");
                    $('.btn_reset_drag_room4').removeClass("no-click");
                    $('.chat_bot_room_4').addClass("d-none");
                    $('.photoChoice_room_4').addClass("d-none");
                    $('.multipleChoice_room_4').addClass("d-none");
                    $('.sendDrawing_room_4').addClass("d-none");
                    
                    $('.pFac_a_room4').addClass("ponto_facultativo-selected");  
                    
                    setupDragDropRoom4()
                    break;
                case 4:
                     // Facultativo
                     playerSFXPlay('robotBtnSimpleClick');
                     $('.chat_bot_room_4').fadeIn().removeClass("d-none");
 
                     $('.multipleChoice_room_4').addClass("d-none");
                     $('.photoChoice_room_4').addClass("d-none");
                     $('.dragChoice_room_4').addClass("d-none");  
                     $('.sendDrawing_room_4').addClass("d-none");
                     
                     $('.pFac_b_room4').addClass("ponto_facultativo-selected");   
                    break;
                case 5:
                    //Facultativo
                    setTimeout(function() {playerSFXPlay('robotTalk');}, 500);
                    playerSFXPlay('robotBtnSimpleClick');
                    $('.sendDrawing_room_4').fadeIn().removeClass("d-none");
                    $('.contentor_room4 .bot_9').fadeIn().removeClass("d-none");          
                    
                    $('.dragChoice_room_4').addClass("d-none");
                    $('.chat_bot_room_4').addClass("d-none");
                    $('.photoChoice_room_4').addClass("d-none");
                    $('.multipleChoice_room_4').addClass("d-none");
                    
                    $('.pFac_c_room4').addClass("ponto_facultativo-selected");   
                    break;
            }
        break;
    }
}

function closeHotSpot(){
    Parallax.start();

    if(courseStatus.rooms_completed[courseStatus.currentRoom] == 1 && courseStatus.completed == 0)
        $(`.btnNextRoom_0${courseStatus.currentRoom}`).removeClass("d-none")
}

// function handleTooltips(){
//     $(".tooltip_small").each(function(){
//         const elem = $(this)
//         const tooltip_exercicio_id = elem.attr("data-exercicioId")
//         if(typeof courseStatus.exercicios[tooltip_exercicio_id] !== "undefined"){
//             if(elem.hasClass("ponto_obrigatorio"))
//                 elem.addClass("ponto_obrigatorio-selected")
//             if(elem.hasClass("ponto_facultativo"))
//                 elem.addClass("ponto_facultativo-selected")
//         }
//     })
// }

function handleRoomVisitedTooltips(){
    for (let index = 0; index < courseStatus.exercicios.length; index++) {
        if(courseStatus.exercicios[index] == "correct" || courseStatus.exercicios[index] == "wrong"){
            const element = $(`.tooltip_small[data-exercicioid=${index}]`)
            if($(element).hasClass("ponto_facultativo"))
                $(element).addClass("ponto_facultativo-selected")
            else
                $(element).addClass("ponto_obrigatorio-selected")
        }
    }
}

function checkMandatoryExercises(roomId){

    function isWrongOrCorrect(testVar){
        let v = false
        if(testVar == "correct" || testVar == "wrong")
            v = true

        return v
    }

    // Camera 1
    if(roomId == 1)
        if(isWrongOrCorrect(courseStatus.exercicios[0]) && isWrongOrCorrect(courseStatus.exercicios[1]))
            gameCompleted_room1()

    // Camera 2
    if(roomId == 2)
        if(isWrongOrCorrect(courseStatus.exercicios[5]) && isWrongOrCorrect(courseStatus.exercicios[6]))
            gameCompleted_room2()
    
    // Camera 3
    if(roomId == 3)
        if(isWrongOrCorrect(courseStatus.exercicios[10]) && isWrongOrCorrect(courseStatus.exercicios[11]))
            gameCompleted_room3()

    // Camera 4
    if(roomId == 4)
        if(isWrongOrCorrect(courseStatus.exercicios[15]) && isWrongOrCorrect(courseStatus.exercicios[16]))
            gameCompleted_room4()
}

var reviewingInstructions = false
function GoToRoom(id, inReview = false){

    if(id == 0){
        reviewingInstructions = true
        $(".intro.instructions").removeClass("d-none").fadeIn()
        $(".intro.instructions .btnContinue").remove()
        $("#instruction-slide-0-5 .navigate-next").remove()
        $("#instruction-slide-0-6").remove()
        $(".instruction-slide").removeClass("active").fadeOut('fast')
        $(".instruction-slide:eq(0)").removeClass("d-none").fadeIn().addClass("active")
    }


    $(".room").addClass("d-none")
    $(`#room${id}-container`).removeClass("d-none").fadeIn()
    courseStatus.currentRoom = id;

    $(".gameCompleted_room" + id).fadeOut().addClass("d-none")
    $(".pontos_room" + id).fadeIn().removeClass("d-none")

    Parallax.stop()
    Parallax.currentViewId = `contentor_room${id}_bg`
    Parallax.start()

    // if(courseStatus.rooms_completed[id] == 1)
    //     $(`.btnNextRoom_0${id}`).removeClass("d-none")

    if(id == 5){
        checkEnvelopesCompletion()
        $(".pointsEarned_room5").fadeOut().addClass("d-none")
    }

}

function score(value, playSFX = true) {

    if(courseStatus.completed == 1)
        return

    if(value == 0)
        return

    var currentScore = courseStatus.score;
    var targetScore = currentScore + value
    var animationSpeed = 50; // Velocidade da animação (em milissegundos)
    var increment = 50; // Incremento da pontuação

    function animateScore() {
        var animation = setInterval(function() {
            currentScore += increment;

            if(currentScore < 1000)
                $(".bg_boder_points").html("00" + currentScore);
            else if(currentScore < 10000)
                $(".bg_boder_points").html("0" + currentScore);
            else
                $(".bg_boder_points").html(currentScore);
            
                if (currentScore >= targetScore) {
                    clearInterval(animation);
            }
        }, animationSpeed);
    }
    animateScore();

    if(playSFX && value > 0)
        $('#sfx-points')[0].play();

    courseStatus.score += value

    updateScore()
}

function updateScore(){

    if(courseStatus.score == 0){
        $(".bg_boder_points").html("00000");
        $(".pointsEarned_room5 .score").text("00000")
        return
    }

    if(courseStatus.score < 1000)
        $(".bg_boder_points").html("00" + courseStatus.score);
    else if(courseStatus.score < 10000)
        $(".bg_boder_points").html("0" + courseStatus.score);
    else
        $(".bg_boder_points").html(courseStatus.score);

    $(".pointsEarned_room5 .score").text(courseStatus.score)
}

function checkEnvelopesCompletion(){
    if(typeof courseStatus.envelopes != "undefined"){
        if(courseStatus.envelopes.length == 5){
            $('.btnNextRoom_05').fadeIn().removeClass("d-none");
        }
        for (let index = 1; index <= courseStatus.envelopes.length; index++) {
            if(courseStatus.envelopes[index] == 1){
                $(`.envelopes_room5 div[data-envelope=${index}]`).addClass("selected")
            }
        }
    }
}

function sendInteraction(interactionId, description){
    const interactionData = {
        id: interactionId,
        question: description,
        answer: "",
        correct: "",
        state:  "",
        objective: ""
    };

    courseInteraction( interactionData )
}

function courseInteraction( {id, question, answer, correct, state, objective} ) {
    /*
        id - theme + _ +questionN, 
        question - string da pergunta,
        answer - string da resposta dada
        correct - string da resposta correta
        state - correct ou incorrect
        objective - theme + _ +questionN
    */

    var time = new Date();
    
    if ( correct === undefined ) {
        correct = answer;
    }
    if ( state === undefined ) {
        state = 'neutral';
    }
    
    if ( objective === undefined ) {
        objective = id;
    }
    
    SB.setInteraction({
        id: '' + id,                             // {String}
        type: 'other',                  // {String}
        objectives: [                                         // {Array}
            {                                                 // {Object}
                id: '' + objective                                     // {String}
            }
        ],
        timestamp: time,                                 // {Object} date start
        correct_responses: [
            {                                                 // {Object}
                pattern: correct                  // {String}
            }
        ],		
        weighting: '1',                                       // {String}
        learner_response: answer,                // {String}
        result: state,                                    // {String} correct, incorrect, neutral
        description: question  // {String} question commonly
    });
}