const Parallax = {
    currentViewId: null,
    container: null,
    isDragging: false,
    startX: 0,
    scrollLeft: 0,

    start: function() {
        this.container = document.querySelector("." + this.currentViewId);

        if(this.container == null)
            return

        this.container.style.cursor = 'grab';

        this.container.addEventListener('mousedown', this.onMouseDown);
        this.container.addEventListener('mouseleave', this.onMouseLeave);
        this.container.addEventListener('mouseup', this.onMouseUp);
        this.container.addEventListener('mousemove', this.onMouseMove);
    },

    stop: function() {

        if(this.container == null)
            return
        
        this.container.removeEventListener('mousedown', this.onMouseDown);
        this.container.removeEventListener('mouseleave', this.onMouseLeave);
        this.container.removeEventListener('mouseup', this.onMouseUp);
        this.container.removeEventListener('mousemove', this.onMouseMove);
        
        this.isDragging = false;
        this.container.style.cursor = 'default';
    },

    onMouseDown: function(e) {
        if (e.button !== 0) return; // Apenas permitir botão do lado esquerdo
        const container = Parallax.container;
        Parallax.isDragging = true;
        Parallax.startX = e.pageX - container.offsetLeft; 
        Parallax.scrollLeft = container.scrollLeft;
        container.style.cursor = 'grabbing';
    },

    onMouseLeave: function() {
        Parallax.isDragging = false;
        Parallax.container.style.cursor = 'grab';
    },

    onMouseUp: function() {
        Parallax.isDragging = false;
        Parallax.container.style.cursor = 'grab';
    },

    onMouseMove: function(e) {
        if (!Parallax.isDragging) return;
        e.preventDefault();
        const container = Parallax.container; // Armazena uma referência local ao contentor
        const x = e.pageX - container.offsetLeft; // Usa a referência local
        const walk = (x - Parallax.startX) * 0.8;
        
        // Obter a transformação atual
        const currentTransform = getComputedStyle(container).transform;
        let currentTranslateX = 0;
    
        // Se houver uma transformação aplicada, extraia o valor de translateX
        if (currentTransform !== 'none') {
            const matrixValues = currentTransform.match(/matrix.*\((.+)\)/)[1].split(', ');
            currentTranslateX = parseFloat(matrixValues[4]);
        }
    
        let newTranslateX = currentTranslateX + walk;
    
        // Verifica se a nova posição está dentro dos limites
        // Substitua 100 e 0 pelos limites que desejar
        const maxTranslateX = 0; // Valor máximo permitido para translateX
        const minTranslateX = -670;   // Valor mínimo permitido para translateX
    
        if (newTranslateX > maxTranslateX) newTranslateX = maxTranslateX;
        if (newTranslateX < minTranslateX) newTranslateX = minTranslateX;
    
        container.style.transform = `translateX(${newTranslateX}px)`;
        Parallax.startX = x; // Atualiza a posição inicial para suavizar o movimento
    }
};

// let currentParallaxId;
// let currentParallaxContainer;
// const Parallax = {
//     currentViewId: null,
//     container: null,
//     mouseDown: false,
//     startX: null, 
//     scrollLeft: null,
//     start: function() {
//         currentParallaxContainer = document.querySelector("#" + currentParallaxId)
//         // currentParallaxContainer = document.querySelector("#" + this.currentViewId)
//         currentParallaxContainer.style.cursor = 'grab';
//         currentParallaxContainer.addEventListener('mousedown', this.startDragging);
//         currentParallaxContainer.addEventListener('mouseleave', this.stopDragging);
//         currentParallaxContainer.addEventListener('mouseup', this.stopDragging);
//         currentParallaxContainer.addEventListener('mousemove', this.move);

//         currentParallaxContainer.scrollLeft = (currentParallaxContainer.scrollWidth - currentParallaxContainer.clientWidth) / 2;
//     },
//     stop: function() {
//         currentParallaxContainer.removeEventListener('mousedown', this.startDragging);
//         currentParallaxContainer.removeEventListener('mouseleave', this.stopDragging);
//         currentParallaxContainer.removeEventListener('mouseup', this.stopDragging);
//         currentParallaxContainer.removeEventListener('mousemove', this.move);
        
//         this.mouseDown = false;
//         // currentParallaxContainer.style.cursor = 'default';
//     },
//     startDragging: function(e) {
//         this.mouseDown = true;
//         this.startX = e.pageX - currentParallaxContainer.offsetLeft;
//         this.scrollLeft = currentParallaxContainer.scrollLeft;
//     },
//     stopDragging: function(e) {
//         this.mouseDown = false;
//         // currentParallaxContainer.style.cursor = 'default';
//     },
//     move: function(e) {
//         e.preventDefault();
//         if(!this.mouseDown) { return; }
//         const x = e.pageX - currentParallaxContainer.offsetLeft;
//         const scroll = x - this.startX;
//         currentParallaxContainer.scrollLeft = this.scrollLeft - scroll;
//     }
// }
